const { createApp } = Vue

createApp({

    data() {
        return {
            machines: [],
            user: {},
            machinsLoaded: false,
        }
    },

    mounted() {

        // Load machines
        this.loadMachines()
        
        // Load user
        this.loadUser()
    },

    computed: {

        activeMachines() {

            let listOfMachines = []

            if (this.isNotEmpty(this.machines)) {

                listOfMachines = _.filter(this.machines, machine => this.isActive(machine.status))

            }

            return listOfMachines
        }
    },

    methods: {

        formatBalance(balance) {

            return Number(balance).toFixed(2)
        },

        formatCost(value) {

            return Number(value).toFixed(0)
        },

        async loadUser() {

            let response = await axios.get('/index.php?m=cloud&action=login')

            response = response.data

            if (response.message) {

                // Its not ok to show message here
            }

            if (response.data) {

                this.user = response.data
            }
        },

        lang(name) {

            let output = name

            _.forEach(words, function(first, second) {

                if (second.toLowerCase() == name.toLowerCase()) {

                    output = first
                }
            })

            return output
        },

        isEmpty(value) {

            if (_.isEmpty(value)) {
                return true
            } else {
                return false
            }
        },

        isNotEmpty(value) {

            if (_.isEmpty(value)) {
                return false
            } else {
                return true
            }
        },

        getProperty(data, name, empty=null) {

            let value = _.get(data, name)

            if (value) {
                return value
            } else {
                return empty
            }
        },

        isOnline(status) {

            if (status == 'online') {
                return true
            } else {
                return false
            }
        },

        isOffline(status) {

            if (status == 'offline') {
                return true
            } else {
                return false
            }
        },

        isActive(status) {

            if (status == 'active') {
                return true
            } else {
                return false
            }
        },

        isPassive(status) {

            if (status == 'offline') {
                return true
            } else {
                return false
            }
        },

        async loadMachines() {

            let response = await axios.get('/index.php?m=cloud&action=machines')

            response = response.data

            if (response.message) {

                // Its not ok to show message here
            }

            if (response.data) {

                this.machines = response.data
                this.machinsLoaded = true
            }
        },

        open(machine) {

            let address = '/modules/addons/cloud/views/autovm/machine.php?m=cloud'

            let params = new URLSearchParams({
                'action': 'pageMachine', 'id': machine.id
            }).toString()

            window.open([address, params].join('&'), "_top")
        },

        opencreatepage(){

            let address = '/modules/addons/cloud/views/autovm/create.php'

            window.open([address], "_top")

        },

        address(machine) {

            let listOfReserves = []

            if (this.isNotEmpty(machine)) {

                listOfReserves = _.filter(machine.reserves, reserve => this.isActive(reserve.status))
            }

            let listOfIPs = []

            _.forEach(listOfReserves, function(reserve) {

                listOfIPs.push(reserve.address.address)
            })

            return listOfIPs.shift()
        },

        online(machine) {

            let status = this.getProperty(machine, 'powerStatus.value')

            if (this.isOnline(status)) {
                return true
            } else {
                return false
            }
        },

        offline(machine) {

            let status = this.getProperty(machine, 'powerStatus.value')

            if (this.isOffline(status)) {
                return true
            } else {
                return false
            }
        },

        lang(name) {

            let output = name

            _.forEach(words, function(first, second) {

                if (second.toLowerCase() == name.toLowerCase()) {

                    output = first
                }
            })

            return output
        }
    }
}).mount('.indexapp')



