const { createApp } = Vue


createApp({

    data() {
        return {
        
            regions: [],
            products: [],
            categories: [],
            user: {},

            confirmDialog: false,
            confirmTitle: null,
            confirmText: null,

            messageDialog: false,
            messageText: null,

            name: null,
            regionId: null,
            regionName: null,
            productId: null,
            productName: null,
            productPrice: null,
            templateId: null,

            themachinename: null,
            themachinessh: null,

            createActionFailed: false,
            createActionSucced: false,
            userClickedCreationBtn: false,
    
        }
    },

    mounted() {

        // Load regions
        this.loadRegions()

        // Load categories
        this.loadCategories()
        
        // Load user
        this.loadUser()

    },


    watch: {
        
        regionId() {
            
            // Load products
            this.loadProducts()
        },

        regionName() {
            
            // Load products
            this.loadProducts()

        },
        
    },

    methods: {
        
        formatBalance(balance, decml = 2) {

            return Number(balance).toFixed(decml)
            
        },
        

        async loadUser() {

            let response = await axios.get('/index.php?m=cloud&action=login')

            response = response.data

            if (response.message) {

                // Its not ok to show message here
            }

            if (response.data) {

                this.user = response.data
            }
        },
        
        openConfirmDialog(title, text) {
            
            // Open dialog
            this.confirmDialog = true

            // Content
            this.confirmText = text
            this.confirmTitle = title

            // Reset click Btn 
            this.createActionFailed = false
            this.createActionSucced = false
            this.userClickedCreationBtn = false

            // Promise
            return new Promise( (resolve) => this.confirmResolve = resolve )

        },


        acceptConfirmDialog() {

            this.confirmResolve(true)

            // Close dialog
            this.confirmDialog = false
            
            // Check Click
            this.userClickedCreationBtn = true

        },

        closeConfirmDialog() {

            this.confirmResolve(false)

            // Close dialog
            this.confirmDialog = false


            // Reset Click BTN
            setTimeout(() => {
                this.createActionFailed = false
                this.createActionSucced = false
                this.userClickedCreationBtn = false    
            }, 500);
            
            

        },

        openMessageDialog(text) {

            // Open dialog
            this.messageDialog = true

            // Content
            this.messageText = text

            // Promise
            return new Promise( (resolve) => this.messageResolve = resolve )
        },

        closeMessageDialog() {

            this.messageResolve(false)

            // Close dialog
            this.messageDialog = false
        },

        isEmpty(value) {

            if (_.isEmpty(value)) {
                return true
            } else {
                return false
            }
        },

        isNotEmpty(value) {

            if (_.isEmpty(value)) {
                return false
            } else {
                return true
            }
        },

        formatPrice(price, decml = 2) {

            return Number(price).toFixed(decml)
        },

        async loadRegions() {

            let response = await axios.get('/index.php?m=cloud&action=regions')

            response = response.data

            if (response.message) {

                // Its not ok to show message here
            }

            if (response.data) {

                this.regions = response.data
            }
        },

        selectRegion(region) {

            this.regionId = region.id
            this.productId = ''
            this.productName = ''
            this.productPrice = null
            this.regionName = region.name
            
        },

        isRegion(region) {
            
            if (this.regionId == region.id) {
                return true
            } else {
                return false
            }
            
        },

        async loadProducts() {

            this.products = []

            let response = await axios.get('/index.php?m=cloud&action=products', {
                params: {
                    id: this.regionId
                }
            })

            response = response.data

            if (response.message) {

                // Its not ok to show message here
            }

            if (response.data) {

                this.products = response.data
            }
        },

        selectProduct(product) {

            this.productId = product.id
            this.productName = product.name
            this.productPrice = product.price
        },

        isProduct(product) {

            if (this.productId == product.id) {
                return true
            } else {
                return false
            }
        },

        async loadCategories() {

            let response = await axios.get('/index.php?m=cloud&action=categories')

            response = response.data

            if (response.message) {

                // Its not ok to show message here
            }

            if (response.data) {

                this.categories = response.data
            }
        },

        async create() {

            let accept = await this.openConfirmDialog(this.lang('Create Machine'), this.lang('Are you sure about this?'))

            if (accept) {
                
                let formData = new FormData()

                if (this.productId) {
                    formData.append('productId', this.productId)
                }
    
                if (this.templateId) {
                    formData.append('templateId', this.templateId)
                }
    
                if (this.themachinename) {
                    formData.append('name', this.themachinename)
                }
    
                let response = await axios.post('/index.php?m=cloud&action=create', formData)

                response = response.data
                
                if (response.message) {

                    this.openMessageDialog(this.lang(response.message))
                    this.createActionFailed = true
                    
                }

                if (response.data) {

                    this.createActionSucced = true

                }
            }
        },


        OpenMachineList(){
            
            window.open('/index.php?m=cloud&action=pageIndex')

        },
        
        
        reloadPage(){
            
            location.reload()

        },
        

        lang(name) {

            let output = name

            _.forEach(words, function(first, second) {

                if (second.toLowerCase() == name.toLowerCase()) {

                    output = first
                }
            })

            return output
        }
    }
}).mount('#createapp')